package com.ejie.ab04b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VmotivosSubsanacionExp;

/**
 * VmotivosSubsanacionExpDaoImpl generated by UDA, 07-jun-2017 16:29:16.
 * @author UDA
 */
 
@Repository
@Transactional
public class VmotivosSubsanacionExpDaoImpl implements VmotivosSubsanacionExpDao {
    private JdbcTemplate jdbcTemplate;
	
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VmotivosSubsanacionExp> rwMap = new RowMapper<VmotivosSubsanacionExp>() {
		public VmotivosSubsanacionExp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new VmotivosSubsanacionExp(
               resultSet.getString("TERAPE"), resultSet.getString("ANOAPE"), resultSet.getInt("NUMAPE"), resultSet.getLong("IDTRAMITE"), resultSet.getLong("TIPOTRAMITE"), resultSet.getLong("IDTAREA"), resultSet.getLong("TIPOTAREA"), resultSet.getString("CODMOTIVO"), resultSet.getString("DESCRIPCIONES"), resultSet.getString("DESCRIPCIONEUS"), resultSet.getString("DESCOTROSES"), resultSet.getString("DESCOTROSEU")
           ); } } ;
           
	private RowMapper<VmotivosSubsanacionExp> rwMapPK = new RowMapper<VmotivosSubsanacionExp>() {
		public VmotivosSubsanacionExp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new VmotivosSubsanacionExp(
				resultSet.getString("TERAPE"), resultSet.getString("ANOAPE"), resultSet.getInt("NUMAPE"), resultSet.getLong("IDTRAMITE"), resultSet.getLong("TIPOTRAMITE"), resultSet.getLong("IDTAREA"), resultSet.getLong("TIPOTAREA"), resultSet.getString("CODMOTIVO"), resultSet.getString("DESCRIPCIONES"), resultSet.getString("DESCRIPCIONEUS"), resultSet.getString("DESCOTROSES"), resultSet.getString("DESCOTROSEU")
           ); } } ;

	/**
     * Rowmapper para Jerarquía
     *
 dataSource DataSource

     */
	private RowMapper<JerarquiaDto< VmotivosSubsanacionExp>> rwMapJerarquia = new RowMapper<JerarquiaDto<VmotivosSubsanacionExp>>() {
		public JerarquiaDto<VmotivosSubsanacionExp> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
	
			VmotivosSubsanacionExp vmotivossubsanacionexp = new VmotivosSubsanacionExp(resultSet.getString("TERAPE"), resultSet.getString("ANOAPE"), resultSet.getInt("NUMAPE"), resultSet.getLong("IDTRAMITE"), resultSet.getLong("TIPOTRAMITE"), resultSet.getLong("IDTAREA"), resultSet.getLong("TIPOTAREA"), resultSet.getString("CODMOTIVO"), resultSet.getString("DESCRIPCIONES"), resultSet.getString("DESCRIPCIONEUS"), resultSet.getString("DESCOTROSES"), resultSet.getString("DESCOTROSEU"));

			JerarquiaDto<VmotivosSubsanacionExp> jerarquia = new JerarquiaDto<VmotivosSubsanacionExp>();
			jerarquia.setModel(vmotivossubsanacionexp);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};


	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource DataSource
	 *
	 * @param dataSource the new data source
	 */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

	/*
	 * OPERACIONES CRUD
	 */

    /**
	 * Inserts a single row in the VmotivosSubsanacionExp table.
	 * 
	 *  vmotivossubsanacionexp VmotivosSubsanacionExp
	 *  VmotivosSubsanacionExp
	 *
	 * @param vmotivossubsanacionexp the vmotivossubsanacionexp
	 * @return the vmotivos subsanacion exp
	 */
	public VmotivosSubsanacionExp add(VmotivosSubsanacionExp vmotivossubsanacionexp) {
    	String query = "INSERT INTO VMOTIVOS_SUBSANACION_EXP (TERAPE, ANOAPE, NUMAPE, ID_TRAMITE, TIPO_TRAMITE, ID_TAREA, TIPO_TAREA, CODMOTIVO, DESCRIPCION_ES, DESCRIPCION_EUS, DESC_OTROS_ES, DESC_OTROS_EU) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, vmotivossubsanacionexp.getTerape(), vmotivossubsanacionexp.getAnoape(), vmotivossubsanacionexp.getNumape(), vmotivossubsanacionexp.getIdTramite(), vmotivossubsanacionexp.getTipoTramite(), vmotivossubsanacionexp.getIdTarea(), vmotivossubsanacionexp.getTipoTarea(), vmotivossubsanacionexp.getCodmotivo(), vmotivossubsanacionexp.getDescripcionEs(), vmotivossubsanacionexp.getDescripcionEus(), vmotivossubsanacionexp.getDescOtrosEs(), vmotivossubsanacionexp.getDescOtrosEu());
		return vmotivossubsanacionexp;
	}

    /**
     * Updates a single row in the VmotivosSubsanacionExp table.
     * 
     *  vmotivossubsanacionexp VmotivosSubsanacionExp
     *  VmotivosSubsanacionExp
     *
     * @param vmotivossubsanacionexp the vmotivossubsanacionexp
     * @return the vmotivos subsanacion exp
     */
    public VmotivosSubsanacionExp update(VmotivosSubsanacionExp vmotivossubsanacionexp) {
		String query = "UPDATE VMOTIVOS_SUBSANACION_EXP SET  WHERE TERAPE=? AND ANOAPE=? AND NUMAPE=? AND ID_TRAMITE=? AND TIPO_TRAMITE=? AND ID_TAREA=? AND TIPO_TAREA=? AND CODMOTIVO=? AND DESCRIPCION_ES=? AND DESCRIPCION_EUS=? AND DESC_OTROS_ES=? AND DESC_OTROS_EU=?";
		this.jdbcTemplate.update(query, vmotivossubsanacionexp.getTerape(), vmotivossubsanacionexp.getAnoape(), vmotivossubsanacionexp.getNumape(), vmotivossubsanacionexp.getIdTramite(), vmotivossubsanacionexp.getTipoTramite(), vmotivossubsanacionexp.getIdTarea(), vmotivossubsanacionexp.getTipoTarea(), vmotivossubsanacionexp.getCodmotivo(), vmotivossubsanacionexp.getDescripcionEs(), vmotivossubsanacionexp.getDescripcionEus(), vmotivossubsanacionexp.getDescOtrosEs(), vmotivossubsanacionexp.getDescOtrosEu());
		return vmotivossubsanacionexp;
	}

    /**
     * Finds a single row in the VmotivosSubsanacionExp table.
     * 
     *  vmotivossubsanacionexp VmotivosSubsanacionExp
     *  VmotivosSubsanacionExp
     *
     * @param vmotivossubsanacionexp the vmotivossubsanacionexp
     * @return the vmotivos subsanacion exp
     */
    @Transactional (readOnly = true)
    public VmotivosSubsanacionExp find(VmotivosSubsanacionExp vmotivossubsanacionexp) {
		String query = "SELECT t1.TERAPE TERAPE, t1.ANOAPE ANOAPE, t1.NUMAPE NUMAPE, t1.ID_TRAMITE IDTRAMITE, t1.TIPO_TRAMITE TIPOTRAMITE, t1.ID_TAREA IDTAREA, t1.TIPO_TAREA TIPOTAREA, t1.CODMOTIVO CODMOTIVO, t1.DESCRIPCION_ES DESCRIPCIONES, t1.DESCRIPCION_EUS DESCRIPCIONEUS, t1.DESC_OTROS_ES DESCOTROSES, t1.DESC_OTROS_EU DESCOTROSEU FROM VMOTIVOS_SUBSANACION_EXP t1  WHERE t1.TERAPE = ?   AND t1.ANOAPE = ?   AND t1.NUMAPE = ?   AND t1.ID_TRAMITE = ?   AND t1.TIPO_TRAMITE = ?   AND t1.ID_TAREA = ?   AND t1.TIPO_TAREA = ?   AND t1.CODMOTIVO = ?   AND t1.DESCRIPCION_ES = ?   AND t1.DESCRIPCION_EUS = ?   AND t1.DESC_OTROS_ES = ?   AND t1.DESC_OTROS_EU = ?  ";
		
		List<VmotivosSubsanacionExp> vmotivossubsanacionexpList = this.jdbcTemplate.query(query, this.rwMap, vmotivossubsanacionexp.getTerape() , vmotivossubsanacionexp.getAnoape() , vmotivossubsanacionexp.getNumape() , vmotivossubsanacionexp.getIdTramite() , vmotivossubsanacionexp.getTipoTramite() , vmotivossubsanacionexp.getIdTarea() , vmotivossubsanacionexp.getTipoTarea() , vmotivossubsanacionexp.getCodmotivo() , vmotivossubsanacionexp.getDescripcionEs() , vmotivossubsanacionexp.getDescripcionEus() , vmotivossubsanacionexp.getDescOtrosEs() , vmotivossubsanacionexp.getDescOtrosEu());
		return (VmotivosSubsanacionExp) DataAccessUtils.uniqueResult(vmotivossubsanacionexpList);
    }

    /**
     * Removes a single row in the VmotivosSubsanacionExp table.
     * 
     *  vmotivossubsanacionexp VmotivosSubsanacionExp
     *
     * @param vmotivossubsanacionexp the vmotivossubsanacionexp
     */
    public void remove(VmotivosSubsanacionExp vmotivossubsanacionexp) {
		String query = "DELETE FROM VMOTIVOS_SUBSANACION_EXP WHERE TERAPE=? AND ANOAPE=? AND NUMAPE=? AND ID_TRAMITE=? AND TIPO_TRAMITE=? AND ID_TAREA=? AND TIPO_TAREA=? AND CODMOTIVO=? AND DESCRIPCION_ES=? AND DESCRIPCION_EUS=? AND DESC_OTROS_ES=? AND DESC_OTROS_EU=?";
		this.jdbcTemplate.update(query, vmotivossubsanacionexp.getTerape() , vmotivossubsanacionexp.getAnoape() , vmotivossubsanacionexp.getNumape() , vmotivossubsanacionexp.getIdTramite() , vmotivossubsanacionexp.getTipoTramite() , vmotivossubsanacionexp.getIdTarea() , vmotivossubsanacionexp.getTipoTarea() , vmotivossubsanacionexp.getCodmotivo() , vmotivossubsanacionexp.getDescripcionEs() , vmotivossubsanacionexp.getDescripcionEus() , vmotivossubsanacionexp.getDescOtrosEs() , vmotivossubsanacionexp.getDescOtrosEu());
    }
    
   /**
    * Finds a list of rows in the VmotivosSubsanacionExp table.
    * 
    *  vmotivossubsanacionexp VmotivosSubsanacionExp
    *  jqGridRequestDto JQGridRequestDto
    *  List<VmotivosSubsanacionExp>
    *
    * @param vmotivossubsanacionexp the vmotivossubsanacionexp
    * @param jqGridRequestDto the jq grid request dto
    * @return the list
    */
	@Transactional (readOnly = true)
    public List<VmotivosSubsanacionExp> findAll(VmotivosSubsanacionExp vmotivossubsanacionexp, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder("SELECT  t1.TERAPE TERAPE,t1.ANOAPE ANOAPE,t1.NUMAPE NUMAPE,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU "); 
		query.append("FROM VMOTIVOS_SUBSANACION_EXP t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vmotivossubsanacionexp); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<VmotivosSubsanacionExp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Finds rows in the VmotivosSubsanacionExp table using like.
	 * 
	 *  vmotivossubsanacionexp VmotivosSubsanacionExp
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *  List<VmotivosSubsanacionExp>
	 *
	 * @param vmotivossubsanacionexp the vmotivossubsanacionexp
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional (readOnly = true)
    public List<VmotivosSubsanacionExp> findAllLike(VmotivosSubsanacionExp vmotivossubsanacionexp, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.TERAPE TERAPE,t1.ANOAPE ANOAPE,t1.NUMAPE NUMAPE,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU "); 
        query.append("FROM VMOTIVOS_SUBSANACION_EXP t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vmotivossubsanacionexp,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<VmotivosSubsanacionExp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	
    /**
	 * Counts rows in the VmotivosSubsanacionExp table.
	 * 
	 *  vmotivossubsanacionexp VmotivosSubsanacionExp
	 *  Long
	 *
	 * @param vmotivossubsanacionexp the vmotivossubsanacionexp
	 * @return the long
	 */
    @Transactional (readOnly = true)
    public Long findAllCount(VmotivosSubsanacionExp vmotivossubsanacionexp) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM VMOTIVOS_SUBSANACION_EXP t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vmotivossubsanacionexp); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}	
	
	/**
	 * Counts rows in the VmotivosSubsanacionExp table using like.
	 * 
	 *  vmotivossubsanacionexp VmotivosSubsanacionExp
	 *  startsWith Boolean
	 *  Long
	 *
	 * @param vmotivossubsanacionexp the vmotivossubsanacionexp
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(VmotivosSubsanacionExp vmotivossubsanacionexp, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM VMOTIVOS_SUBSANACION_EXP t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vmotivossubsanacionexp,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of VmotivosSubsanacionExp selected for rup_table.
	 * 
	 *  vmotivossubsanacionexp VmotivosSubsanacionExp
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *  List<TableRowDto<VmotivosSubsanacionExp>>
	 *
	 * @param vmotivossubsanacionexp the vmotivossubsanacionexp
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override 
	public List<TableRowDto<VmotivosSubsanacionExp>> reorderSelection(VmotivosSubsanacionExp vmotivossubsanacionexp, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.TERAPE TERAPE,t1.ANOAPE ANOAPE,t1.NUMAPE NUMAPE,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU "); 
		// FROM
        query.append("FROM VMOTIVOS_SUBSANACION_EXP t1 ");
		// FILTRADO
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vmotivossubsanacionexp,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");		
		
		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL =  JQGridManager.getReorderQuery(query, jqGridRequestDto, VmotivosSubsanacionExp.class, filterParamList, "TERAPE,ANOAPE,NUMAPE,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU" );

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<VmotivosSubsanacionExp>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams VmotivosSubsanacionExp
	 *  searchParams VmotivosSubsanacionExp
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *  List<TableRowDto<VmotivosSubsanacionExp>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VmotivosSubsanacionExp>> search(VmotivosSubsanacionExp filterParams, VmotivosSubsanacionExp searchParams, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.TERAPE TERAPE,t1.ANOAPE ANOAPE,t1.NUMAPE NUMAPE,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU "); 
		// FROM
        query.append("FROM VMOTIVOS_SUBSANACION_EXP t1 ");	
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");
		
		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");
		
		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, VmotivosSubsanacionExp.class, filterParamList, searchSQL, searchParamList, from_alias, "TERAPE,ANOAPE,NUMAPE,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU");
		
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<VmotivosSubsanacionExp>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());		
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filtervmotivossubsanacionexp VmotivosSubsanacionExp
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *
	 * @param filtervmotivossubsanacionexp the filtervmotivossubsanacionexp
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(VmotivosSubsanacionExp filtervmotivossubsanacionexp, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT t1.TERAPE TERAPE,t1.ANOAPE ANOAPE,t1.NUMAPE NUMAPE,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU "); 
		// FROM
        query.append("FROM VMOTIVOS_SUBSANACION_EXP t1 ");	
		
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtervmotivossubsanacionexp, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, VmotivosSubsanacionExp.class, query, params, "TERAPE,ANOAPE,NUMAPE,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical VmotivosSubsanacionExp table.
	 * 
	 *  filterVmotivosSubsanacionExp VmotivosSubsanacionExp
	 *  jqGridRequestDto JQGridRequestDto
	 *  List<JerarquiaDto<VmotivosSubsanacionExp>>
	 *
	 * @param filterVmotivosSubsanacionExp the filter vmotivos subsanacion exp
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<JerarquiaDto<VmotivosSubsanacionExp>> findAllLikeJerarquia(VmotivosSubsanacionExp filterVmotivosSubsanacionExp, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.TERAPE TERAPE,t1.ANOAPE ANOAPE,t1.NUMAPE NUMAPE,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU "); 
		// FROM
        //StringBuilder from = new StringBuilder("FROM VMOTIVOS_SUBSANACION_EXP t1 ");
        List<String> from = new ArrayList<String>();
        from.add("VMOTIVOS_SUBSANACION_EXP");
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterVmotivosSubsanacionExp, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "TERAPE,ANOAPE,NUMAPE,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU", "ID_PADRE", "NOMBRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins, businessFilters, businessParams);

		//PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy.
	 * 
	 *  filterVmotivosSubsanacionExp VmotivosSubsanacionExp
	 *  jqGridRequestDto JQGridRequestDto
	 *  Long
	 *
	 * @param filterVmotivosSubsanacionExp the filter vmotivos subsanacion exp
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the long
	 */
	@Override
	public Long findAllLikeCountJerarquia(VmotivosSubsanacionExp filterVmotivosSubsanacionExp, JQGridRequestDto jqGridRequestDto) {
		// FROM
        //StringBuilder from = new StringBuilder("FROM VMOTIVOS_SUBSANACION_EXP t1 ");
        List<String> from = new ArrayList<String>();
        from.add("VMOTIVOS_SUBSANACION_EXP");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterVmotivosSubsanacionExp, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "TERAPE,ANOAPE,NUMAPE,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);


		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows.
	 * 
	 *  filterVmotivosSubsanacionExp VmotivosSubsanacionExp
	 *  jqGridRequestDto JQGridRequestDto
	 *  List<TableRowDto<VmotivosSubsanacionExp>>
	 *
	 * @param filterVmotivosSubsanacionExp the filter vmotivos subsanacion exp
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VmotivosSubsanacionExp>> findAllChild(VmotivosSubsanacionExp filterVmotivosSubsanacionExp, JQGridRequestDto jqGridRequestDto) {
		
		// FROM
        //StringBuilder from = new StringBuilder("FROM VMOTIVOS_SUBSANACION_EXP t1 ");
        List<String> from = new ArrayList<String>();
        from.add("VMOTIVOS_SUBSANACION_EXP");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterVmotivosSubsanacionExp, false);
		
		//MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "TERAPE,ANOAPE,NUMAPE,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<VmotivosSubsanacionExp>(this.rwMapPK, "TERAPE,ANOAPE,NUMAPE,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */
	 	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the VmotivosSubsanacionExp entity .
	 * 
	 *  vmotivossubsanacionexp VmotivosSubsanacionExp
	 *            Bean with the criteria values to filter by.
	 *  Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 *
	 * @param vmotivossubsanacionexp the vmotivossubsanacionexp
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (VmotivosSubsanacionExp vmotivossubsanacionexp){
		
		StringBuilder where = new StringBuilder(VmotivosSubsanacionExpDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getTerape() != null ) {
			where.append(" AND t1.TERAPE = ?");
			params.add(vmotivossubsanacionexp.getTerape());
		}
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getAnoape() != null ) {
			where.append(" AND t1.ANOAPE = ?");
			params.add(vmotivossubsanacionexp.getAnoape());
		}
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getNumape() != null ) {
			where.append(" AND t1.NUMAPE = ?");
			params.add(vmotivossubsanacionexp.getNumape());
		}
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getIdTramite() != null ) {
			where.append(" AND t1.ID_TRAMITE = ?");
			params.add(vmotivossubsanacionexp.getIdTramite());
		}
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getTipoTramite() != null ) {
			where.append(" AND t1.TIPO_TRAMITE = ?");
			params.add(vmotivossubsanacionexp.getTipoTramite());
		}
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getIdTarea() != null ) {
			where.append(" AND t1.ID_TAREA = ?");
			params.add(vmotivossubsanacionexp.getIdTarea());
		}
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getTipoTarea() != null ) {
			where.append(" AND t1.TIPO_TAREA = ?");
			params.add(vmotivossubsanacionexp.getTipoTarea());
		}
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getCodmotivo() != null ) {
			where.append(" AND t1.CODMOTIVO = ?");
			params.add(vmotivossubsanacionexp.getCodmotivo());
		}
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getDescripcionEs() != null ) {
			where.append(" AND t1.DESCRIPCION_ES = ?");
			params.add(vmotivossubsanacionexp.getDescripcionEs());
		}
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getDescripcionEus() != null ) {
			where.append(" AND t1.DESCRIPCION_EUS = ?");
			params.add(vmotivossubsanacionexp.getDescripcionEus());
		}
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getDescOtrosEs() != null ) {
			where.append(" AND t1.DESC_OTROS_ES = ?");
			params.add(vmotivossubsanacionexp.getDescOtrosEs());
		}
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getDescOtrosEu() != null ) {
			where.append(" AND t1.DESC_OTROS_EU = ?");
			params.add(vmotivossubsanacionexp.getDescOtrosEu());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the VmotivosSubsanacionExp entity .
	 * 
	 *  vmotivossubsanacionexp VmotivosSubsanacionExp
	 *            Bean with the criteria values to filter by.
	 *  startsWith Boolean
	 *  Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 *
	 * @param vmotivossubsanacionexp the vmotivossubsanacionexp
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap (VmotivosSubsanacionExp vmotivossubsanacionexp, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(VmotivosSubsanacionExpDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getTerape() != null ) {
			where.append(" AND UPPER(t1.TERAPE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(vmotivossubsanacionexp.getTerape().toUpperCase() +"%");
			}else{
				params.add("%"+vmotivossubsanacionexp.getTerape().toUpperCase() +"%");
			}
			where.append(" AND t1.TERAPE IS NOT NULL");
	     }			
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getAnoape() != null ) {
			where.append(" AND UPPER(t1.ANOAPE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(vmotivossubsanacionexp.getAnoape().toUpperCase() +"%");
			}else{
				params.add("%"+vmotivossubsanacionexp.getAnoape().toUpperCase() +"%");
			}
			where.append(" AND t1.ANOAPE IS NOT NULL");
	     }			
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getNumape() != null ) {
			where.append(" AND t1.NUMAPE = ?");
			params.add(vmotivossubsanacionexp.getNumape());
	     }			
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getIdTramite() != null ) {
			where.append(" AND t1.ID_TRAMITE = ?");
			params.add(vmotivossubsanacionexp.getIdTramite());
	     }			
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getTipoTramite() != null ) {
			where.append(" AND t1.TIPO_TRAMITE = ?");
			params.add(vmotivossubsanacionexp.getTipoTramite());
	     }			
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getIdTarea() != null ) {
			where.append(" AND t1.ID_TAREA = ?");
			params.add(vmotivossubsanacionexp.getIdTarea());
	     }			
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getTipoTarea() != null ) {
			where.append(" AND t1.TIPO_TAREA = ?");
			params.add(vmotivossubsanacionexp.getTipoTarea());
	     }			
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getCodmotivo() != null ) {
			where.append(" AND UPPER(t1.CODMOTIVO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(vmotivossubsanacionexp.getCodmotivo().toUpperCase() +"%");
			}else{
				params.add("%"+vmotivossubsanacionexp.getCodmotivo().toUpperCase() +"%");
			}
			where.append(" AND t1.CODMOTIVO IS NOT NULL");
	     }			
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getDescripcionEs() != null ) {
			where.append(" AND UPPER(t1.DESCRIPCION_ES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(vmotivossubsanacionexp.getDescripcionEs().toUpperCase() +"%");
			}else{
				params.add("%"+vmotivossubsanacionexp.getDescripcionEs().toUpperCase() +"%");
			}
			where.append(" AND t1.DESCRIPCION_ES IS NOT NULL");
	     }			
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getDescripcionEus() != null ) {
			where.append(" AND UPPER(t1.DESCRIPCION_EUS) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(vmotivossubsanacionexp.getDescripcionEus().toUpperCase() +"%");
			}else{
				params.add("%"+vmotivossubsanacionexp.getDescripcionEus().toUpperCase() +"%");
			}
			where.append(" AND t1.DESCRIPCION_EUS IS NOT NULL");
	     }			
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getDescOtrosEs() != null ) {
			where.append(" AND UPPER(t1.DESC_OTROS_ES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(vmotivossubsanacionexp.getDescOtrosEs().toUpperCase() +"%");
			}else{
				params.add("%"+vmotivossubsanacionexp.getDescOtrosEs().toUpperCase() +"%");
			}
			where.append(" AND t1.DESC_OTROS_ES IS NOT NULL");
	     }			
		if (vmotivossubsanacionexp  != null  && vmotivossubsanacionexp.getDescOtrosEu() != null ) {
			where.append(" AND UPPER(t1.DESC_OTROS_EU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(vmotivossubsanacionexp.getDescOtrosEu().toUpperCase() +"%");
			}else{
				params.add("%"+vmotivossubsanacionexp.getDescOtrosEu().toUpperCase() +"%");
			}
			where.append(" AND t1.DESC_OTROS_EU IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

